
$(document).ready(function() {
    initBBCodeEditor();
});

function initBBCodeEditor() {
    // BBCode button functionality
    $('.toolbar-btn[data-bbcode]').on('click', function() {
        const bbcode = $(this).data('bbcode');
        const textarea = $(this).closest('.bbcode-editor').find('.bbcode-textarea');
        
        insertBBCode(textarea, bbcode);
    });
    
    // Emoji picker toggle
    $('.emoji-btn').on('click', function(e) {
        e.stopPropagation();
        const picker = $(this).closest('.emoji-group').find('.emoji-picker');
        picker.toggleClass('show');
    });
    
    // Close emoji picker when clicking elsewhere
    $(document).on('click', function() {
        $('.emoji-picker').removeClass('show');
    });
    
    // Prevent picker from closing when clicking inside it
    $('.emoji-picker').on('click', function(e) {
        e.stopPropagation();
    });
    
    // Insert emoji
    $('.emoji-item').on('click', function() {
        const emoji = $(this).data('emoji');
        const textarea = $(this).closest('.bbcode-editor').find('.bbcode-textarea');
        insertAtCursor(textarea[0], emoji);
        $('.emoji-picker').removeClass('show');
    });
    
    // Preview toggle
    $('.preview-btn').on('click', function() {
        const editor = $(this).closest('.bbcode-editor');
        const textarea = editor.find('.bbcode-textarea');
        const preview = editor.find('.bbcode-preview');
        
        $(this).toggleClass('active');
        
        if ($(this).hasClass('active')) {
            $(this).text('Edit');
            textarea.hide();
            preview.show();
            
            // Convert BBCode to HTML for preview
            const bbcode = textarea.val();
            const html = convertBBCodeToHtml(bbcode);
            preview.html(html);
        } else {
            $(this).text('Preview');
            preview.hide();
            textarea.show();
        }
    });
}

// Insert BBCode tags around selected text or at cursor position
function insertBBCode(textarea, bbcode) {
    const element = textarea[0];
    const start = element.selectionStart;
    const end = element.selectionEnd;
    const text = element.value;
    let selectedText = text.substring(start, end);
    let replacement = '';
    
    switch(bbcode) {
        case 'url':
            const url = prompt('Enter URL:', 'http://');
            if (url) {
                if (selectedText) {
                    replacement = `[url=${url}]${selectedText}[/url]`;
                } else {
                    replacement = `[url=${url}]${url}[/url]`;
                }
            }
            break;
            
        case 'img':
            const imgUrl = prompt('Enter image URL:', 'http://');
            if (imgUrl) {
                replacement = `[img]${imgUrl}[/img]`;
            }
            break;
            
        case 'list':
            if (!selectedText) {
                replacement = "[list]\n[*] Item 1\n[*] Item 2\n[*] Item 3\n[/list]";
            } else {
                replacement = `[list]\n${selectedText.split('\n').map(line => `[*] ${line}`).join('\n')}\n[/list]`;
            }
            break;
            
        default:
            if (selectedText) {
                replacement = `[${bbcode}]${selectedText}[/${bbcode}]`;
            } else {
                replacement = `[${bbcode}][/${bbcode}]`;
                // Place cursor between tags
                setTimeout(() => {
                    element.selectionStart = start + bbcode.length + 2;
                    element.selectionEnd = start + bbcode.length + 2;
                }, 0);
            }
    }
    
    if (replacement) {
        // Insert the replacement
        element.value = text.substring(0, start) + replacement + text.substring(end);
        
        // Update cursor position if there's selected text
        if (selectedText) {
            element.selectionStart = start + replacement.length;
            element.selectionEnd = start + replacement.length;
        }
        
        // Trigger change event
        $(element).trigger('change');
        
        // Focus back on the textarea
        element.focus();
    }
}

// Helper function to insert text at cursor position
function insertAtCursor(element, text) {
    const start = element.selectionStart;
    const end = element.selectionEnd;
    const value = element.value;
    
    element.value = value.substring(0, start) + text + value.substring(end);
    
    // Update cursor position
    element.selectionStart = start + text.length;
    element.selectionEnd = start + text.length;
    
    // Trigger change event
    $(element).trigger('change');
    
    // Focus back on the textarea
    element.focus();
}

// Convert BBCode to HTML for preview
function convertBBCodeToHtml(bbcode) {
    if (!bbcode) return '';
    
    let html = bbcode;
    
    // Basic formatting
    html = html.replace(/\[b\]([\s\S]*?)\[\/b\]/g, '<strong>$1</strong>');
    html = html.replace(/\[i\]([\s\S]*?)\[\/i\]/g, '<em>$1</em>');
    html = html.replace(/\[u\]([\s\S]*?)\[\/u\]/g, '<u>$1</u>');
    html = html.replace(/\[s\]([\s\S]*?)\[\/s\]/g, '<del>$1</del>');
    
    // Links
    html = html.replace(/\[url\](https?:\/\/[^\s\[\]]+)\[\/url\]/g, '<a href="$1" target="_blank">$1</a>');
    html = html.replace(/\[url=(https?:\/\/[^\s\[\]]+)\]([\s\S]*?)\[\/url\]/g, '<a href="$1" target="_blank">$2</a>');
    
    // Images
    html = html.replace(/\[img\](https?:\/\/[^\s\[\]]+)\[\/img\]/g, '<img src="$1" alt="Image">');
    
    // Code
    html = html.replace(/\[code\]([\s\S]*?)\[\/code\]/g, '<code>$1</code>');
    
    // Quotes
    html = html.replace(/\[quote\]([\s\S]*?)\[\/quote\]/g, '<blockquote>$1</blockquote>');
    html = html.replace(/\[quote=(.*?)\]([\s\S]*?)\[\/quote\]/g, '<blockquote><strong>$1 wrote:</strong><br>$2</blockquote>');
    
    // Lists
    html = html.replace(/\[list\]([\s\S]*?)\[\/list\]/g, function(match, content) {
        let listContent = content.replace(/\[\*\](.*?)(?=\[\*\]|$)/g, '<li>$1</li>');
        return '<ul>' + listContent + '</ul>';
    });
    
    // Line breaks
    html = html.replace(/\n/g, '<br>');
    
    return html;
}